//	Critical Mass Be
//	started 12/7/1997
//	Hamish Carr

#pragma once

#include "CMBrain.h"						//	include the interface

CMBrainParms::CMBrainParms(CMBoard *newSourceBoard, int newRow, int newDepth, 
			BStatusBar *newStatusBar, int *newResult, bool newIsFirstTurn)
	{
	sourceBoard = newSourceBoard;				//	just copy them into place
	row = newRow;
	depth = newDepth;
	theStatusBar = newStatusBar;
	result = newResult;
	isFirstTurn = newIsFirstTurn;
	} // end of CMBrainParms constructor

CMBrain::CMBrain()							//	default constructor
	{
	srand(system_time());					//	get the time & seed the random number generator
	} // end of CMBrain()

void CMBrain::RandomBlue(CMBoard *sourceBoard,  int *row, int *col)
										//	thinks up a blue move - returns 
										//	coordinates in the parameters
	{
	int *theCell;							//	pointer to walk with
	int *stop;							//	and a stop mark
	int *stop2;							//	and another stop mark
	int nGoodMoves = 0;						//	how many equally good moves there are
	int randomNumber;						//	a random number for selecting a move
	double randFract;						//	a random number reduced to a fraction
	int countOfGoodMoves = 0;				//	used to locate the desired move	
	CMBoard *theBoard;						//	the board to use to evaluate the result
	
	theBoard = new CMBoard(*sourceBoard);		//	allocate a new board	
	theCell = theBoard->bombs + V_STEP + H_STEP;
										//	set the startpoint
	stop = theBoard->bombs + ARRAY_SIZE - V_STEP;
										//	set an endpoint
	for (; theCell < stop; theCell += 2)		//	move to next line in array
		{
		stop2 = theCell + V_STEP - 2;			//	set the horizontal stop
		for (; theCell < stop2; theCell++)	//	walk along the row
			{
			if (*theCell >= 0)				//	i.e. a legal move for blue
				{
				nGoodMoves++;				//	and count one more good move
				*theCell = 1;				//	flag it as a good move
				}
			else *theCell = 0;				//	otherwise mark it as useless				
			} // end of loop along rows
		} // end of loop down rows

	randFract = rand();						//	get a random integer
	randFract /= RAND_MAX;					//	convert it to a float in [0,1]
	randomNumber = nGoodMoves * randFract +1;	//	convert to an integer

	theCell = theBoard->bombs + V_STEP + H_STEP;
										//	set the startpoint
	stop = theBoard->bombs + ARRAY_SIZE - V_STEP;
										//	set an endpoint
	for (; theCell < stop; theCell += 2)		//	move to next line in array
		{
		stop2 = theCell + V_STEP - 2;			//	set the horizontal stop
		for (; theCell < stop2; theCell++)	//	walk along the row
			{
			countOfGoodMoves += *theCell;		//	add this to the count
			if (countOfGoodMoves == randomNumber)
										//	ah, we found it
				{
				*row = (theCell - theBoard->bombs) / V_STEP;
				*col = (theCell + V_STEP - stop2 -1) / H_STEP;
				return;					//	so leave
				} // end of case where we find the move
			} // end of loop along rows
		} // end of loop down rows

	} // end of RandomBlue()
	
void CMBrain::RandomRed(CMBoard *sourceBoard, int *row, int *col)
										//	thinks up a red move - returns 
										//	coordinates in the parameters
	{
	int *theCell;							//	pointer to walk with
	int *stop;							//	and a stop mark
	int *stop2;							//	and another stop mark
	int nGoodMoves = 0;						//	how many equally good moves there are
	int randomNumber;						//	a random number for selecting a move
	double randFract;						//	a random number reduced to a fraction
	int countOfGoodMoves = 0;				//	used to locate the desired move	
	CMBoard *theBoard;						//	the board to use to evaluate the result
	
	theBoard = new CMBoard(*sourceBoard);		//	allocate a new board	
		
	theCell = theBoard->bombs + V_STEP + H_STEP;
										//	set the startpoint
	stop = theBoard->bombs + ARRAY_SIZE - V_STEP;
										//	set an endpoint
	for (; theCell < stop; theCell += 2)		//	move to next line in array
		{
		stop2 = theCell + V_STEP - 2;			//	set the horizontal stop
		for (; theCell < stop2; theCell++)		//	walk along the row
			{
			if (*theCell <= 0)				//	i.e. a legal move for red
				{
				nGoodMoves++;				//	and count one more good move
				*theCell = 1;				//	flag it as a good move
				}
			else *theCell = 0;				//	otherwise mark it as useless				
			} // end of loop along rows
		} // end of loop down rows

	randFract = rand();						//	get a random integer
	randFract /= RAND_MAX;					//	convert it to a float in [0,1]
	randomNumber = nGoodMoves * randFract +1;	//	convert to an integer

	theCell = theBoard->bombs + V_STEP + H_STEP;
										//	set the startpoint
	stop = theBoard->bombs + ARRAY_SIZE - V_STEP;
										//	set an endpoint
	for (; theCell < stop; theCell += 2)		//	move to next line in array
		{
		stop2 = theCell + V_STEP - 2;			//	set the horizontal stop
		for (; theCell < stop2; theCell++)		//	walk along the row
			{
			countOfGoodMoves += *theCell;		//	add this to the count
			if (countOfGoodMoves == randomNumber)
										//	ah, we found it
				{
				*row = (theCell - theBoard->bombs) / V_STEP;
				*col = (theCell + V_STEP - stop2 -1) / H_STEP;
				return;					//	so leave
				} // end of case where we find the move
			} // end of loop along rows
		} // end of loop down rows

	} // end of RandomRed()

void CMBrain::SmartBlue(CMBoard *sourceBoard, int *row, int *col)
										//	thinks up a blue move - returns 
										//	coordinates in the parameters
	{
	int *theCell;							//	pointer to walk with
	int *theEvalCell;						//	pointer into evalBoard
	int *theTestCell;						//	pointer into testBoard
	int *stop;							//	and a stop mark
	int *stop2;							//	and another stop mark
	int nGoodMoves = 0;						//	how many equally good moves there are
	int randomNumber;						//	a random number for selecting a move
	double randFract;						//	a random number reduced to a fraction
	int countOfGoodMoves = 0;				//	used to locate the desired move	
	CMBoard evalBoard;						//	used as a convenient array for storing results
	CMBoard testBoard;						//	used for testing moves
	int value;							//	the value of any particular cell
	int bestValue;							//	best value discovered so far
	CMBoard *theBoard;						//	the board to use to evaluate the result
	
	theBoard = new CMBoard(*sourceBoard);		//	allocate a new board	
	bestValue = BLUE_WIPED_OUT;				//	we hope to find something better than this		
	theCell = theBoard->bombs + V_STEP + H_STEP;	//	set the startpoint
	theEvalCell = evalBoard.bombs + V_STEP + H_STEP;	//	set the startpoint
	theTestCell = testBoard.bombs + V_STEP + H_STEP;	//	set the startpoint
	stop = theBoard->bombs + ARRAY_SIZE - V_STEP;//	set an endpoint
	for (; theCell < stop; theCell += 2)		//	move to next line in array
		{
		stop2 = theCell + V_STEP - 2;			//	set the horizontal stop
		for (; theCell < stop2; theCell++)		//	walk along the row
			{
			if (*theCell >= 0)				//	i.e. a legal move for blue
				{
				testBoard.Copy(*theBoard);	//	make a temporary copy in test
				(*theTestCell)++;			//	i.e. add a bomb directly to it
				testBoard.ExplodeBlue();		//	do any explosions
				value = testBoard.Evaluate();	//	evaluate the result
				if (value > bestValue)		//	if it's a new maximum
					{
					bestValue = value;		//	set the new best value
					nGoodMoves = 1;		//	there's now at least one
					} // end of new max
				else if (value == bestValue)	//	i.e. it matches the existing best
					nGoodMoves++;			//	add one to the number of good moves
				*theEvalCell = value;		//	store the value
				} // end of test for valid cell
			else // i.e. invalid cell		
				*theEvalCell = ILLEGAL_BLUE;	//	set it to a flag for an illegal move
			theEvalCell++;					//	step the eval cell along as well
			theTestCell++;					//	step the test cell along as well
			} // end of loop along rows
		theTestCell += 2;					//	step the test cell down as well
		theEvalCell += 2;					//	step the eval cell down as well
		} // end of loop down rows

	randFract = rand();						//	get a random integer
	randFract /= RAND_MAX;					//	convert it to a float in [0,1]
	randomNumber = nGoodMoves * randFract +1;	//	convert to an integer

	theCell = evalBoard.bombs + V_STEP + H_STEP;//	set the startpoint
	stop = evalBoard.bombs + ARRAY_SIZE - V_STEP;
										//	set an endpoint
	for (; theCell < stop; theCell += 2)		//	move to next line in array
		{
		stop2 = theCell + V_STEP - 2;			//	set the horizontal stop
		for (; theCell < stop2; theCell++)		//	walk along the row
			{
			if (*theCell == bestValue)		//	if it's one of the maxima
				countOfGoodMoves ++;		//	count it 
			if (countOfGoodMoves == randomNumber)
										//	ah, we found it
				{
				*row = (theCell - evalBoard.bombs) / V_STEP;
				*col = (theCell + V_STEP - stop2 -1) / H_STEP;
				return;					//	so leave
				} // end of case where we find the move
			} // end of loop along rows
		} // end of loop down rows
	} // end of SmartBlue()
	
void CMBrain::SmartRed(CMBoard *sourceBoard, int *row, int *col, bool isFirstTurn)
										//	thinks up a red move - returns 
										//	coordinates in the parameters
	{
	int *theCell;							//	pointer to walk with
	int *theEvalCell;						//	pointer into evalBoard
	int *theTestCell;						//	pointer into testBoard
	int *stop;							//	and a stop mark
	int *stop2;							//	and another stop mark
	int nGoodMoves = 0;						//	how many equally good moves there are
	int randomNumber;						//	a random number for selecting a move
	double randFract;						//	a random number reduced to a fraction
	int countOfGoodMoves = 0;				//	used to locate the desired move	
	CMBoard evalBoard;						//	used as a convenient array for storing results
	CMBoard testBoard;						//	used for testing moves
	int value;							//	the value of any particular cell
	int bestValue;							//	best value discovered so far
	CMBoard *theBoard;						//	the board to use to evaluate the result
	
	theBoard = new CMBoard(*sourceBoard);		//	allocate a new board				
	bestValue = RED_WIPED_OUT;				//	we hope to find something better than this		
	theCell = theBoard->bombs + V_STEP + H_STEP;	//	set the startpoint
	theEvalCell = evalBoard.bombs + V_STEP + H_STEP;	//	set the startpoint
	theTestCell = testBoard.bombs + V_STEP + H_STEP;	//	set the startpoint
	stop = theBoard->bombs + ARRAY_SIZE - V_STEP;//	set an endpoint
	for (; theCell < stop; theCell += 2)		//	move to next line in array
		{
		stop2 = theCell + V_STEP - 2;			//	set the horizontal stop
		for (; theCell < stop2; theCell++)		//	walk along the row
			{
			if (*theCell <= 0)				//	i.e. a legal move for red
				{
				testBoard.Copy(*theBoard);	//	make a temporary copy in test
				(*theTestCell)--;			//	i.e. add a bomb directly to it
				testBoard.ExplodeRed();		//	do any explosions
				value = testBoard.Evaluate(isFirstTurn);
										//	evaluate the result
				if (value < bestValue)		//	if it's a new minimum
					{
					bestValue = value;		//	set the new best value
					nGoodMoves = 1;		//	there's now at least one
					} // end of new max
				else if (value == bestValue)	//	i.e. it matches the existing best
					nGoodMoves++;			//	add one to the number of good moves
				*theEvalCell = value;		//	store the value
				} // end of test for valid cell
			else // i.e. invalid cell		
				*theEvalCell = ILLEGAL_RED;	//	set it to a flag for an illegal move
			theEvalCell++;					//	step the eval cell along as well
			theTestCell++;					//	step the test cell along as well
			} // end of loop along rows
		theTestCell += 2;					//	step the test cell down as well
		theEvalCell += 2;					//	step the eval cell down as well
		} // end of loop down rows

	randFract = rand();						//	get a random integer
	randFract /= RAND_MAX;					//	convert it to a float in [0,1]
	randomNumber = nGoodMoves * randFract +1;	//	convert to an integer

	theCell = evalBoard.bombs + V_STEP + H_STEP;//	set the startpoint
	stop = evalBoard.bombs + ARRAY_SIZE - V_STEP;
										//	set an endpoint
	for (; theCell < stop; theCell += 2)		//	move to next line in array
		{
		stop2 = theCell + V_STEP - 2;			//	set the horizontal stop
		for (; theCell < stop2; theCell++)		//	walk along the row
			{
			if (*theCell == bestValue)		//	if it's one of the minima
				countOfGoodMoves ++;		//	count it 
			if (countOfGoodMoves == randomNumber)
										//	ah, we found it
				{
				*row = (theCell - evalBoard.bombs) / V_STEP;
				*col = (theCell + V_STEP - stop2 -1) / H_STEP;
				return;					//	so leave
				} // end of case where we find the move
			} // end of loop along rows
		} // end of loop down rows
	} // end of SmartRed()
	
void CMBrain::MinMaxBlue(CMBoard *sourceBoard, int *row, int *col, int depth, BStatusBar *theStatusBar)
										//	does a bounded minmax search for blue
	{
	int *theCell;							//	pointer to walk with
	int *theEvalCell;						//	pointer into evalBoard
	int *theTestCell;						//	pointer into testBoard
	int *stop;							//	and a stop mark
	int *stop2;							//	and another stop mark
	int nGoodMoves = 0;						//	how many equally good moves there are
	int randomNumber;						//	a random number for selecting a move
	double randFract;						//	a random number reduced to a fraction
	int countOfGoodMoves = 0;				//	used to locate the desired move	
	CMBoard evalBoard;						//	used as a convenient array for storing results
	CMBoard testBoard;						//	used for testing moves
	int value;							//	the value of any particular cell
	int bestValue;							//	best value discovered so far
	CMBoard *theBoard;						//	the board to use to evaluate the result
	rgb_color bar_colour;					//	colour to use in the status bar
	BMessenger messageBoy(theStatusBar);		//	create a messenger to send to the status bar	
	BMessage *anUpdate;						//	an update message
	
	bar_colour.blue = 255;					//	set the components
	bar_colour.red = bar_colour.green = bar_colour.alpha = 0;
	theStatusBar->SetText("Thinking . . .");	//	set the label
	theStatusBar->SetBarColor(bar_colour);		//	set the bar to red
	theStatusBar->SetMaxValue(30);			//	set the max size of the bar
	theBoard = new CMBoard(*sourceBoard);		//	allocate a new board	
	bestValue = BLUE_WIPED_OUT;				//	we hope to find something better than this		
	theCell = theBoard->bombs + V_STEP + H_STEP;	//	set the startpoint
	theEvalCell = evalBoard.bombs + V_STEP + H_STEP;	//	set the startpoint
	theTestCell = testBoard.bombs + V_STEP + H_STEP;	//	set the startpoint
	stop = theBoard->bombs + ARRAY_SIZE - V_STEP;//	set an endpoint
	for (; theCell < stop; theCell += 2)		//	move to next line in array
		{
		stop2 = theCell + V_STEP - 2;			//	set the horizontal stop
		for (; theCell < stop2; theCell++)		//	walk along the row
			{
			if (*theCell >= 0)				//	i.e. a legal move for blue
				{
				testBoard.Copy(*theBoard);	//	make a temporary copy in test
				(*theTestCell)++;			//	i.e. add a bomb directly to it
				testBoard.ExplodeBlue();		//	do any explosions
				value = testBoard.Evaluate();	//	always evaluate (slow, but sure)
				if (value != RED_WIPED_OUT && depth > 1)	
										//	i.e. recursive case
					value = MinMaxDeeperRed(&testBoard, depth-1);
				if (value > bestValue)		//	if it's a new maximum
					{
					bestValue = value;		//	set the new best value
					nGoodMoves = 1;		//	there's now at least one
					} // end of new max
				else if (value == bestValue)	//	i.e. it matches the existing best
					nGoodMoves++;			//	add one to the number of good moves
				*theEvalCell = value;		//	store the value
				} // end of test for valid cell
			else // i.e. invalid cell		
				*theEvalCell = ILLEGAL_BLUE;	//	set it to a flag for an illegal move
			anUpdate = new BMessage(B_UPDATE_STATUS_BAR);
			anUpdate->AddFloat("delta", 1.0);
			messageBoy.SendMessage(anUpdate);	//	add one to the number considered
			theEvalCell++;					//	step the eval cell along as well
			theTestCell++;					//	step the test cell along as well
			} // end of loop along rows
		theTestCell += 2;					//	step the test cell down as well
		theEvalCell += 2;					//	step the eval cell down as well
		} // end of loop down rows

	randFract = rand();						//	get a random integer
	randFract /= RAND_MAX;					//	convert it to a float in [0,1]
	randomNumber = nGoodMoves * randFract +1;	//	convert to an integer

	theCell = evalBoard.bombs + V_STEP + H_STEP;//	set the startpoint
	stop = evalBoard.bombs + ARRAY_SIZE - V_STEP;
										//	set an endpoint
	for (; theCell < stop; theCell += 2)		//	move to next line in array
		{
		stop2 = theCell + V_STEP - 2;			//	set the horizontal stop
		for (; theCell < stop2; theCell++)		//	walk along the row
			{
			if (*theCell == bestValue)		//	if it's one of the maxima
				countOfGoodMoves ++;		//	count it 
			if (countOfGoodMoves == randomNumber)
										//	ah, we found it
				{
				*row = (theCell - evalBoard.bombs) / V_STEP;
				*col = (theCell + V_STEP - stop2 -1) / H_STEP;
				messageBoy.SendMessage(B_RESET_STATUS_BAR);
				return;					//	so leave
				} // end of case where we find the move
			} // end of loop along rows
		} // end of loop down rows
	} // end of MinMaxBlue()
	
void CMBrain::MinMaxRed(CMBoard *sourceBoard, int *row, int *col, int depth, BStatusBar *theStatusBar, bool isFirstTurn)
										//	does a bounded minmax search for red
	{
	int *theCell;							//	pointer to walk with
	int *theEvalCell;						//	pointer into evalBoard
	int *theTestCell;						//	pointer into testBoard
	int *stop;							//	and a stop mark
	int *stop2;							//	and another stop mark
	int nGoodMoves = 0;						//	how many equally good moves there are
	int randomNumber;						//	a random number for selecting a move
	double randFract;						//	a random number reduced to a fraction
	int countOfGoodMoves = 0;				//	used to locate the desired move	
	CMBoard evalBoard;						//	used as a convenient array for storing results
	CMBoard testBoard;						//	used for testing moves
	int value;							//	the value of any particular cell
	int bestValue;							//	best value discovered so far
	CMBoard *theBoard;						//	the board to use to evaluate the result
	rgb_color bar_colour;					//	colour to use in the status bar
	BMessenger messageBoy(theStatusBar);		//	create a messenger to send to the status bar	
	BMessage *anUpdate;						//	an update message
	
	bar_colour.red = 255;					//	set the components
	bar_colour.blue = bar_colour.green = bar_colour.alpha = 0;
	theStatusBar->SetText("Thinking . . .");	//	set the label
	theStatusBar->SetBarColor(bar_colour);		//	set the bar to red
	theStatusBar->SetMaxValue(30);			//	set the max size of the bar
	theBoard = new CMBoard(*sourceBoard);		//	allocate a new board	
	bestValue = RED_WIPED_OUT;				//	we hope to find something better than this		
	theCell = theBoard->bombs + V_STEP + H_STEP;	//	set the startpoint
	theEvalCell = evalBoard.bombs + V_STEP + H_STEP;	//	set the startpoint
	theTestCell = testBoard.bombs + V_STEP + H_STEP;	//	set the startpoint
	stop = theBoard->bombs + ARRAY_SIZE - V_STEP;//	set an endpoint
	for (; theCell < stop; theCell += 2)		//	move to next line in array
		{
		stop2 = theCell + V_STEP - 2;			//	set the horizontal stop
		for (; theCell < stop2; theCell++)		//	walk along the row
			{
			if (*theCell <= 0)				//	i.e. a legal move for blue
				{
				testBoard.Copy(*theBoard);	//	make a temporary copy in test
				(*theTestCell)--;			//	i.e. add a bomb directly to it
				testBoard.ExplodeRed();		//	do any explosions
				value = testBoard.Evaluate(isFirstTurn);	
										//	always evaluate (slow, but sure)
				if (value != BLUE_WIPED_OUT && depth > 1)	
										//	i.e. recursive case
					value = MinMaxDeeperBlue(&testBoard, depth-1);
				if (value < bestValue)		//	if it's a new maximum
					{
					bestValue = value;		//	set the new best value
					nGoodMoves = 1;		//	there's now at least one
					} // end of new max
				else if (value == bestValue)	//	i.e. it matches the existing best
					nGoodMoves++;			//	add one to the number of good moves
				*theEvalCell = value;		//	store the value
				} // end of test for valid cell
			else // i.e. invalid cell		
				*theEvalCell = ILLEGAL_RED;	//	set it to a flag for an illegal move
			anUpdate = new BMessage(B_UPDATE_STATUS_BAR);
			anUpdate->AddFloat("delta", 1.0);
			messageBoy.SendMessage(anUpdate);	//	add one to the number considered
			theEvalCell++;					//	step the eval cell along as well
			theTestCell++;					//	step the test cell along as well
			} // end of loop along rows
		theTestCell += 2;					//	step the test cell down as well
		theEvalCell += 2;					//	step the eval cell down as well
		} // end of loop down rows

	randFract = rand();						//	get a random integer
	randFract /= RAND_MAX;					//	convert it to a float in [0,1]
	randomNumber = nGoodMoves * randFract +1;	//	convert to an integer

	theCell = evalBoard.bombs + V_STEP + H_STEP;//	set the startpoint
	stop = evalBoard.bombs + ARRAY_SIZE - V_STEP;
										//	set an endpoint
	for (; theCell < stop; theCell += 2)		//	move to next line in array
		{
		stop2 = theCell + V_STEP - 2;			//	set the horizontal stop
		for (; theCell < stop2; theCell++)		//	walk along the row
			{
			if (*theCell == bestValue)		//	if it's one of the maxima
				countOfGoodMoves ++;		//	count it 
			if (countOfGoodMoves == randomNumber)
										//	ah, we found it
				{
				*row = (theCell - evalBoard.bombs) / V_STEP;
				*col = (theCell + V_STEP - stop2 -1) / H_STEP;
				messageBoy.SendMessage(B_RESET_STATUS_BAR);
				return;					//	so leave
				} // end of case where we find the move
			} // end of loop along rows
		} // end of loop down rows
	} // end of MinMaxRed()

long CMBrain::MinMaxDeeperBlue(CMBoard *theBoard, int depth)
										//	does deeper levels, where we don't care about row, col
										//	scrambles the board passed in
	{
	int *theCell;							//	pointer to walk with
	int *theTestCell;						//	pointer into testBoard
	int *stop;							//	and a stop mark
	int *stop2;							//	and another stop mark
	CMBoard testBoard;						//	used for testing moves
	int value;							//	the value of any particular cell
	int bestValue;							//	best value discovered so far
		
	bestValue = BLUE_WIPED_OUT;				//	we hope to find something better than this		
	theCell = theBoard->bombs + V_STEP + H_STEP;	//	set the startpoint
	theTestCell = testBoard.bombs + V_STEP + H_STEP;	//	set the startpoint
	stop = theBoard->bombs + ARRAY_SIZE - V_STEP;//	set an endpoint
	for (; theCell < stop; theCell += 2)		//	move to next line in array
		{
		stop2 = theCell + V_STEP - 2;			//	set the horizontal stop
		for (; theCell < stop2; theCell++)		//	walk along the row
			{
			if (*theCell >= 0)				//	i.e. a legal move for blue
				{
				testBoard.Copy(*theBoard);	//	make a temporary copy in test
				(*theTestCell)++;			//	i.e. add a bomb directly to it
				testBoard.ExplodeBlue();		//	do any explosions
				value = testBoard.Evaluate();	//	always evaluate (slow, but sure)
				if (value != RED_WIPED_OUT && depth > 1)
										//	i.e. recursive case - but don't look further on wipeout
					value = MinMaxDeeperRed(&testBoard, depth-1);
				if (value > bestValue)		//	if it's a new maximum
					bestValue = value;		//	set the new best value
				} // end of test for valid cell
			theTestCell++;					//	step the test cell along as well
			} // end of loop along rows
		theTestCell += 2;					//	step the test cell down as well
		} // end of loop down rows
	return bestValue;						//	return the best result for blue
	} // end of MinMaxDeeperBlue()
	
long CMBrain::MinMaxDeeperRed(CMBoard *theBoard, int depth)
										//	does deeper levels, where we don't care about row, col
	{
	int *theCell;							//	pointer to walk with
	int *theTestCell;						//	pointer into testBoard
	int *stop;							//	and a stop mark
	int *stop2;							//	and another stop mark
	CMBoard testBoard;						//	used for testing moves
	int value;							//	the value of any particular cell
	int bestValue;							//	best value discovered so far
		
	bestValue = RED_WIPED_OUT;				//	we hope to find something better than this		
	theCell = theBoard->bombs + V_STEP + H_STEP;	//	set the startpoint
	theTestCell = testBoard.bombs + V_STEP + H_STEP;	//	set the startpoint
	stop = theBoard->bombs + ARRAY_SIZE - V_STEP;//	set an endpoint
	for (; theCell < stop; theCell += 2)		//	move to next line in array
		{
		stop2 = theCell + V_STEP - 2;			//	set the horizontal stop
		for (; theCell < stop2; theCell++)		//	walk along the row
			{
			if (*theCell <= 0)				//	i.e. a legal move for red
				{
				testBoard.Copy(*theBoard);	//	make a temporary copy in test
				(*theTestCell)--;			//	i.e. add a bomb directly to it
				testBoard.ExplodeRed();		//	do any explosions
				value = testBoard.Evaluate();	//	always evaluate (slow, but sure)
				if (value != BLUE_WIPED_OUT && depth > 1)	
										//	i.e. recursive case
					value = MinMaxDeeperBlue(&testBoard, depth-1);
				if (value < bestValue)		//	if it's a new maximum
					bestValue = value;		//	set the new best value
				} // end of test for valid cell
			theTestCell++;					//	step the test cell along as well
			} // end of loop along rows
		theTestCell += 2;					//	step the test cell down as well
		} // end of loop down rows
	return bestValue;						//	return the best result for blue
	} // end of MinMaxDeeperRed()
	
	
void CMBrain::ThreadedMinMaxBlue(CMBoard *sourceBoard, int *row, int *col, int depth, BStatusBar *theStatusBar)
										//	threaded brain to do bounded minmax search for blue
	{
	int *theCell;							//	pointer to walk with
	int *stop;							//	and a stop mark
	int *stop2;							//	and another stop mark
	int nGoodMoves = 0;						//	how many equally good moves there are
	int randomNumber;						//	a random number for selecting a move
	double randFract;						//	a random number reduced to a fraction
	int countOfGoodMoves = 0;				//	used to locate the desired move	
	CMBoard evalBoard;						//	used as a convenient array for storing results
	CMBoard testBoard;						//	used for testing moves
	int bestValue;							//	best value discovered so far
	rgb_color bar_colour;					//	colour to use in the status bar
	BMessenger messageBoy(theStatusBar);		//	create a messenger to send to the status bar	
	long i;								//	an index for walking down rows
	CMBrainParms *theBrainParms;				//	data to pass to the threads
	status_t exit_value;					//	dummy to catch exit values
	
	bar_colour.blue = 255;					//	set the components
	bar_colour.red = bar_colour.green = bar_colour.alpha = 0;
	theStatusBar->SetText("Thinking . . .");	//	set the label
	theStatusBar->SetBarColor(bar_colour);		//	set the bar to red
	theStatusBar->SetMaxValue(30);			//	set the max size of the bar

	for (i = 1; i <= N_ROWS; i++)				//	walk down the rows
		{
		theBrainParms = new CMBrainParms(sourceBoard, i, depth, theStatusBar, evalBoard.bombs + i*V_STEP + H_STEP);
										//	set up the parameters to pass
		the_threads[i] = spawn_thread(MinMaxRowBlue, "Rodin SubThread", thoughtPriority, (void *) theBrainParms);
		resume_thread(the_threads[i]);		//	and set it rolling
		}

	for (i = 1; i <= N_ROWS; i++)				//	walk down the rows
		wait_for_thread(the_threads[i], &exit_value);
										//	don't proceed until all are done

	bestValue = BLUE_WIPED_OUT;				//	we hope to find something better than this		
	theCell = evalBoard.bombs + V_STEP + H_STEP;	//	set the startpoint
	stop = evalBoard.bombs + ARRAY_SIZE - V_STEP;//	set an endpoint
	for (; theCell < stop; theCell += 2)		//	move to next line in array
		{
		stop2 = theCell + V_STEP - 2;			//	set the horizontal stop
		for (; theCell < stop2; theCell++)		//	walk along the row
			{
			if (*theCell > bestValue)		//	if it's a new minimum
				{
				bestValue = *theCell;		//	set the new best value
				nGoodMoves = 1;			//	there's now at least one
				} // end of new min
			else if (*theCell == bestValue)	//	i.e. it matches the existing best
				nGoodMoves++;				//	add one to the number of good moves
			} // end of loop along rows
		} // end of loop down rows

	randFract = rand();						//	get a random integer
	randFract /= RAND_MAX;					//	convert it to a float in [0,1]
	randomNumber = nGoodMoves * randFract +1;	//	convert to an integer

	theCell = evalBoard.bombs + V_STEP + H_STEP;//	set the startpoint
	stop = evalBoard.bombs + ARRAY_SIZE - V_STEP;
										//	set an endpoint
	for (; theCell < stop; theCell += 2)		//	move to next line in array
		{
		stop2 = theCell + V_STEP - 2;			//	set the horizontal stop
		for (; theCell < stop2; theCell++)		//	walk along the row
			{
			if (*theCell == bestValue)		//	if it's one of the maxima
				countOfGoodMoves ++;		//	count it 
			if (countOfGoodMoves == randomNumber)
										//	ah, we found it
				{
				*row = (theCell - evalBoard.bombs) / V_STEP;
				*col = (theCell + V_STEP - stop2 -1) / H_STEP;
				messageBoy.SendMessage(B_RESET_STATUS_BAR);
				return;					//	so leave
				} // end of case where we find the move
			} // end of loop along rows
		} // end of loop down rows
	} // end of ThreadedMinMaxBlue()

void CMBrain::ThreadedMinMaxRed(CMBoard *sourceBoard, int *row, int *col, int depth, BStatusBar *theStatusBar, bool isFirstTurn)
										//	threaded brain to do bounded minmax search for blue
	{
	int *theCell;							//	pointer to walk with
	int *stop;							//	and a stop mark
	int *stop2;							//	and another stop mark
	int nGoodMoves = 0;						//	how many equally good moves there are
	int randomNumber;						//	a random number for selecting a move
	double randFract;						//	a random number reduced to a fraction
	int countOfGoodMoves = 0;				//	used to locate the desired move	
	CMBoard evalBoard;						//	used as a convenient array for storing results
	CMBoard testBoard;						//	used for testing moves
	int bestValue;							//	best value discovered so far
	rgb_color bar_colour;					//	colour to use in the status bar
	BMessenger messageBoy(theStatusBar);		//	create a messenger to send to the status bar	
	long i;								//	an index for walking down rows
	CMBrainParms *theBrainParms;				//	data to pass to the threads
	status_t exit_value;					//	dummy to catch exit values
	
	bar_colour.red = 255;					//	set the components
	bar_colour.blue = bar_colour.green = bar_colour.alpha = 0;
	theStatusBar->SetText("Thinking . . .");	//	set the label
	theStatusBar->SetBarColor(bar_colour);		//	set the bar to red
	theStatusBar->SetMaxValue(30);			//	set the max size of the bar

	for (i = 1; i <= N_ROWS; i++)				//	walk down the rows
		{
		theBrainParms = new CMBrainParms(sourceBoard, i, depth, theStatusBar, evalBoard.bombs + i*V_STEP + H_STEP, isFirstTurn);
										//	set up the parameters to pass
		the_threads[i] = spawn_thread(MinMaxRowRed, "Rodin SubThread", thoughtPriority, (void *) theBrainParms);
		resume_thread(the_threads[i]);		//	and set it rolling
		}

	for (i = 1; i <= N_ROWS; i++)				//	walk down the rows
		wait_for_thread(the_threads[i], &exit_value);
										//	don't proceed until all are done

	bestValue = RED_WIPED_OUT;				//	we hope to find something better than this		
	theCell = evalBoard.bombs + V_STEP + H_STEP;	//	set the startpoint
	stop = evalBoard.bombs + ARRAY_SIZE - V_STEP;//	set an endpoint
	for (; theCell < stop; theCell += 2)		//	move to next line in array
		{
		stop2 = theCell + V_STEP - 2;			//	set the horizontal stop
		for (; theCell < stop2; theCell++)		//	walk along the row
			{
			if (*theCell < bestValue)		//	if it's a new minimum
				{
				bestValue = *theCell;		//	set the new best value
				nGoodMoves = 1;			//	there's now at least one
				} // end of new min
			else if (*theCell == bestValue)	//	i.e. it matches the existing best
				nGoodMoves++;				//	add one to the number of good moves
			} // end of loop along rows
		} // end of loop down rows

	randFract = rand();						//	get a random integer
	randFract /= RAND_MAX;					//	convert it to a float in [0,1]
	randomNumber = nGoodMoves * randFract +1;	//	convert to an integer

	theCell = evalBoard.bombs + V_STEP + H_STEP;//	set the startpoint
	stop = evalBoard.bombs + ARRAY_SIZE - V_STEP;
										//	set an endpoint
	for (; theCell < stop; theCell += 2)		//	move to next line in array
		{
		stop2 = theCell + V_STEP - 2;			//	set the horizontal stop
		for (; theCell < stop2; theCell++)		//	walk along the row
			{
			if (*theCell == bestValue)		//	if it's one of the maxima
				countOfGoodMoves ++;		//	count it 
			if (countOfGoodMoves == randomNumber)
										//	ah, we found it
				{
				*row = (theCell - evalBoard.bombs) / V_STEP;
				*col = (theCell + V_STEP - stop2 -1) / H_STEP;
				messageBoy.SendMessage(B_RESET_STATUS_BAR);
				return;					//	so leave
				} // end of case where we find the move
			} // end of loop along rows
		} // end of loop down rows
	} // end of ThreadedMinMaxRed()

long CMBrain::MinMaxRowBlue(void *theBrainParms)
										//	static so that we can pass it to a thread
	{
	int *theCell;							//	pointer to walk with
	int *theTestCell;						//	pointer into testBoard
	int *stop2;							//	and another stop mark
	CMBoard evalBoard;						//	used as a convenient array for storing results
	CMBoard testBoard;						//	used for testing moves
	int value;							//	the value of any particular cell
	CMBoard *theBoard;						//	the board to use to evaluate the result
	CMBrainParms *BP = (CMBrainParms *) theBrainParms;
	BMessenger messageBoy(BP->theStatusBar);	//	create a messenger to send to the status bar	
	BMessage *anUpdate;						//	an update message

	theBoard = new CMBoard(*(BP->sourceBoard));	//	allocate a new board	
	theCell = theBoard->bombs + (BP->row*V_STEP) + H_STEP;	//	set the startpoint
	theTestCell = testBoard.bombs + (BP->row*V_STEP) + H_STEP;	//	set the startpoint
	stop2 = theCell + V_STEP - 2;				//	set the horizontal stop
	for (; theCell < stop2; theCell++)			//	walk along the row
		{
		if (*theCell >= 0)					//	i.e. a legal move for blue
			{
			testBoard.Copy(*theBoard);		//	make a temporary copy in test
			(*theTestCell)++;				//	i.e. add a bomb directly to it
			testBoard.ExplodeBlue();			//	do any explosions
			value = testBoard.Evaluate(BP->isFirstTurn);	
										//	always evaluate (slow, but sure)
			if (value != RED_WIPED_OUT && BP->depth > 1)	
										//	i.e. recursive case
				*(BP->result) = aBrain.MinMaxDeeperRed(&testBoard, BP->depth-1);
			else
				*(BP->result) = value;		//	just use the one we just found
			} // end of test for valid cell
		else // i.e. invalid cell		
			*(BP->result) = ILLEGAL_BLUE;		//	set it to a flag for an illegal move
		anUpdate = new BMessage(B_UPDATE_STATUS_BAR);
		anUpdate->AddFloat("delta", 1.0);
		messageBoy.SendMessage(anUpdate);	//	add one to the number considered
		BP->result++;						//	step the eval cell along as well
		theTestCell++;						//	step the test cell along as well
		} // end of loop along rows
	return B_NO_ERROR;
	} // end of MinMaxRowBlue()
		
long CMBrain::MinMaxRowRed(void *theBrainParms)
										//	static so that we can pass it to a thread
	{
	int *theCell;							//	pointer to walk with
	int *theTestCell;						//	pointer into testBoard
	int *stop2;							//	and another stop mark
	CMBoard evalBoard;						//	used as a convenient array for storing results
	CMBoard testBoard;						//	used for testing moves
	int value;							//	the value of any particular cell
	CMBoard *theBoard;						//	the board to use to evaluate the result
	CMBrainParms *BP = (CMBrainParms *) theBrainParms;
	BMessenger messageBoy(BP->theStatusBar);	//	create a messenger to send to the status bar	
	BMessage *anUpdate;						//	an update message

	theBoard = new CMBoard(*(BP->sourceBoard));	//	allocate a new board	
	theCell = theBoard->bombs + (BP->row*V_STEP) + H_STEP;	//	set the startpoint
	theTestCell = testBoard.bombs + (BP->row*V_STEP) + H_STEP;	//	set the startpoint
	stop2 = theCell + V_STEP - 2;				//	set the horizontal stop
	for (; theCell < stop2; theCell++)			//	walk along the row
		{
		if (*theCell <= 0)					//	i.e. a legal move for red
			{
			testBoard.Copy(*theBoard);		//	make a temporary copy in test
			(*theTestCell)--;				//	i.e. add a bomb directly to it
			testBoard.ExplodeRed();			//	do any explosions
			value = testBoard.Evaluate(BP->isFirstTurn);	
										//	always evaluate (slow, but sure)
			if (value != BLUE_WIPED_OUT && BP->depth > 1)	
										//	i.e. recursive case
				*(BP->result) = aBrain.MinMaxDeeperBlue(&testBoard, BP->depth-1);
			else
				*(BP->result) = value;		//	just use the one we just found
			} // end of test for valid cell
		else // i.e. invalid cell		
			*(BP->result) = ILLEGAL_RED;		//	set it to a flag for an illegal move
		anUpdate = new BMessage(B_UPDATE_STATUS_BAR);
		anUpdate->AddFloat("delta", 1.0);
		messageBoy.SendMessage(anUpdate);	//	add one to the number considered
		BP->result++;						//	step the eval cell along as well
		theTestCell++;						//	step the test cell along as well
		} // end of loop along rows
	return B_NO_ERROR;
	} // end of MinMaxRowRed()
		
void CMBrain::kill_threads()					//	used for destroying threads
	{
	long i;								//	loop index
	
	for (i = 0; i < 5; i++)					//	walk through the threads
		kill_thread(the_threads[i]);			//	killing each one
	}; // end of kill_threads